<?php
/**
 *
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.
 *
 * SuiteCRM is an extension to SugarCRM Community Edition developed by SalesAgility Ltd.
 * Copyright (C) 2011 - 2019 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo and "Supercharged by SuiteCRM" logo. If the display of the logos is not
 * reasonably feasible for technical reasons, the Appropriate Legal Notices must
 * display the words "Powered by SugarCRM" and "Supercharged by SuiteCRM".
 */

if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

$mod_strings = array(
    'LBL_CAPTCHA_HELP_TEXT' => 'Captcha is a challenge-response test used to ensure that the response is not generated by a computer. Obtain a Public key and a Private key from reCAPTCHA at http://recaptcha.net/.',
    'CAPTCHA' => 'Captcha Validation',
    'CAPTCHA_PRIVATE_KEY' => 'Captcha private Key',
    'CAPTCHA_PUBLIC_KEY' => 'Captcha public Key',
    'ENABLE_CAPTCHA' => 'Enable reCAPTCHA Validations',
    'ERR_PUBLIC_CAPTCHA_KEY' => 'Invalid Captcha Key',
    'BTN_REBUILD_CONFIG' => 'Rebuild',
    'EXPORT_DELIMITER' => 'Export Delimiter',
    'ADMIN_EXPORT_ONLY' => 'Admin export only',
    'EXPORT' => 'Export Settings',
    'EXPORT_CHARSET' => 'Default Character Set for Import and Export',
    'DISABLE_EXPORT' => 'Disable export',
    'DESC_DROPDOWN_EDITOR' => 'Add, delete, or change the dropdown lists',
    'DESC_FILES_INSTALLED' => 'The following upgrades have been installed:',
    'DESC_FILES_QUEUED' => 'The following modules are ready to be installed:',
    'DESC_IFRAME' => 'Add tabs which can display any web site',

    'DOWNLOAD_QUESTION' => 'Are you sure you wish to download the selected package(s)?',

    'SEARCHING_UPDATES' => 'Searching for updates...',
    'DOWNLOADING' => 'Downloading...',
    'DL_PACKAGES_DOWNLOADING' => 'Downloading',
    'DL_PACKAGES_OF' => 'of',
    'DL_PACKAGES_PACKAGES' => 'Package(s)',
    'LOADING_CATEGORIES' => 'Loading categories...',
    'SEARCHING_PACKAGES' => 'Searching for packages...',
    'AUTHENTICATING' => 'Authenticating...',

    'LBL_MINUTES' => 'Minutes',
    'LBL_HOURS' => 'Hours',
    'LBL_DAYS' => 'Days',
    'LBL_WEEKS' => 'Weeks',
    'LBL_MONTHS' => 'Months',

    'LBL_MONDAY' => 'Monday',
    'LBL_TUESDAY' => 'Tuesday',
    'LBL_WEDNESDAY' => 'Wednesday',
    'LBL_THURSDAY' => 'Thursday',
    'LBL_FRIDAY' => 'Friday',
    'LBL_SATURDAY' => 'Saturday',
    'LBL_SUNDAY' => 'Sunday',

    'LBL_PUBLIC_KEY' => 'Public Key',
    'LBL_PRIVATE_KEY' => 'Private Key',

    'ERR_INVALID_LOCALE_NAME_FORMAT_UPGRADE' => 'The "Name Format" that was set before the upgrade is no longer supported. The format has been automatically set to the default. Please select a new format and click "Save" to remove this message.',

    'ERR_CANNOT_CREATE_RESTORE_FILE' => 'Error: Could not create restore file',
    'ERR_CREDENTIALS_MISSING' => 'Your SuiteCRM credentials are missing.',
    'ERR_DELETE_RECORD' => 'A record number must be specified to delete the account.',
    'ERR_ENABLE_CURL' => 'Please ensure that you have curl enabled.',
    'ERR_INCORRECT_REGEX' => 'The regular expression in the Regex Requirement field contains incorrect syntax. Please check the expression and provide the correct syntax',
    'ERR_NO_COLUMNS_TO_EXPAND' => 'Error: Database does not contain any varchar, char or text columns to expand.',
    'ERR_NOT_IMPLEMENTED' => 'This function is not currently implemented for this configuration.',

    'ERR_SMTP_SERVER_NOT_SET' => 'Warning: An SMTP server for outbound emails is not configured in Email Settings. It must be configured in order to send passwords to users.',
    'ERR_UW_ACCEPT_LICENSE' => 'Before proceeding you must accept the License Agreement',
    'ERR_UW_CONFIG_FAILED' => "Error writing out config.php file.",
    'ERR_UW_COPY_FAILED' => 'Could not copy file ',
    'ERR_UW_INVALID_VIEW' => 'Invalid View specified.',
    'ERR_UW_NO_DEPENDENCY' => "The following dependencies were not found on the system.",
    'ERR_UW_NO_FILES' => "File(s) to copy not specified.",
    'ERR_UW_NO_INSTALL_FILE' => "Install file not specified.",
    'ERR_UW_NO_LANG_DESC' => "Language description not specified.",
    'ERR_UW_NO_LANG' => "Language name not specified.",
    'ERR_UW_NO_MANIFEST' => "The zip file is missing a manifest.php file. Cannot proceed.",
    'ERR_UW_NO_MODE' => "Mode of operation not specified.",
    'ERR_UW_NO_TEMP_DIR' => "Temp directory to copy files from not specified.",
    'ERR_UW_NO_UPDATE_RECORD' => 'Could not locate installation record of',
    'ERR_UW_NO_UPLOAD_FILE' => "Please click Browse to select a file from your system to upload.<br>\n",
    'ERR_UW_NO_VIEW' => "View not defined. Please go to the Administration home to navigate to this page.",
    'ERR_UW_NOT_ACCEPTIBLE_TYPE' => "You can only upload module packs, theme packs, and language packs on this page.",
    'ERR_UW_NOT_RECOGNIZED' => 'is not recognized',
    'ERR_UW_NOT_VALID_UPLOAD' => 'Not valid upload.',
    'ERR_UW_ONLY_PATCHES' => "You can only upload patches on this page.",
    'ERR_UW_REMOVE_FAILED' => 'Could not remove file ',
    'ERR_UW_UPDATE_CONFIG' => "Error updating config.php with new version information.",
    'ERR_UW_UPLOAD_ERROR' => "There was an error uploading the file, please try again!<br>\n",
    'ERROR_MANIFEST_TYPE' => 'Manifest file must specify the package type.',
    'ERROR_PACKAGE_TYPE' => 'Manifest file specifies an unrecognized package type',
    'ERROR_VERSION_INCOMPATIBLE' => 'The uploaded file is not compatible with this version of SuiteCRM: ',
    'HDR_LOGIN_PANEL' => 'Please enter your SuiteCRM Login credentials.',
    'HEARTBEAT_MESSAGE' => "<BR>The SuiteCRM Updates mechanism allows your server to check to see if an update for your version of SuiteCRM is available.",
    'LBL_ACCEPT_TERMS' => 'Accept Terms and Conditions',
    'LBL_ACCEPT' => 'Accept',
    'LBL_ADMINISTRATION_HOME_TITLE' => 'System',
    'LBL_ADMINISTRATION_HOME_DESC' => 'Configure the system-wide settings according to the specifications of your organization. Users can override some of the default locale settings within their user settings page.',
    'LBL_ALLOW_USER_TABS' => 'Allow users to select modules to appear in the navigation bar',
    'LBL_AVAILABLE_UPDATES' => 'Available Updates',
    'LBL_BACKUP_BACK_HOME' => 'Back to Admin Home',
    'LBL_BACKUP_CONFIRM' => 'Confirm Settings',
    'LBL_BACKUP_CONFIRMED' => 'Settings confirmed. Press backup to perform the backup.',
    'LBL_BACKUP_DIRECTORY_ERROR' => 'You must specify a Backup directory.',
    'LBL_BACKUP_DIRECTORY_EXISTS' => 'Backup directory does not exist, and could not be created.',
    'LBL_BACKUP_DIRECTORY_NOT_WRITABLE' => 'Backup directory exists, but is not writable.',
    'LBL_BACKUP_DIRECTORY_WRITABLE' => 'Must be writable by SuiteCRM',
    'LBL_BACKUP_DIRECTORY' => 'Directory:',
    'LBL_BACKUP_FILE_AS_SUB' => 'Target file already exists as a sub-directory in the specified backup directory',
    'LBL_BACKUP_FILE_EXISTS' => 'The target file already exists in directory.',
    'LBL_BACKUP_FILE_STORED' => 'Backup successfully stored as',
    'LBL_BACKUP_FILENAME_ERROR' => 'Backup filename must be specified.',
    'LBL_BACKUP_FILENAME' => 'Filename:',
    'LBL_BACKUP_INSTRUCTIONS_1' => 'The purpose of this tool is to assist in creating backups of the SuiteCRM application files. (Database backups should also be performed regularly. Please refer to your database vendor\'s documentation for information on how to backup your database.)',
    'LBL_BACKUP_INSTRUCTIONS_2' => 'To backup your SuiteCRM application files in a .zip file, enter the following information:',
    'LBL_BACKUP_RUN_BACKUP' => 'Run Backup',
    'LBL_BACKUPS_TITLE' => 'Backups',
    'LBL_BACKUPS' => 'Backup SuiteCRM files',
    'LBL_BUG_TITLE' => 'Bugs',
    'LBL_BUG_DESC' => 'Maintain a list of releases for your product. Active releases are displayed in the Releases drop-down menus in bug records created within the Bugs module.',
    'LBL_CANCEL_BUTTON_TITLE' => 'Cancel',
    'LBL_CHANGE_NAME_MODULES' => 'Change the names of the modules appearing within the application',
    'LBL_CHECK_NOW_LABEL' => 'Check Now',
    'LBL_CHECK_NOW_TITLE' => 'Check Now',
    'LBL_CONFIGURE_TABS_AND_SUBPANELS_DESC' => 'Choose which modules are displayed in the navigation bar and which subpanels are displayed system-wide',
    'LBL_CLEAR_CHART_DATA_CACHE_FINDING' => 'Finding files...',
    'LBL_CLEAR_CHART_DATA_CACHE_DELETING1' => 'Deleting chart data cache files...',
    'LBL_CLEAR_CHART_DATA_CACHE_DELETING2' => 'deleting:',
    'LBL_CLEAR_UNIFIED_SEARCH_CACHE_DELETING1' => 'Deleting unified search cache files...',
    'LBL_CLEAR_UNIFIED_SEARCH_CACHE_DELETING2' => 'deleting:',
    'LBL_CONFIG_CHECK' => 'Config Check',
    'LBL_CONFIG_AJAX' => 'Configure AJAX User Interface',
    'LBL_CONFIG_AJAX_DESC' => 'Performance and page-rendering times are improved in AJAX UI-enabled modules because full page refreshes are not required in those modules. If you are experiencing display issues with modules that are not compatible with AJAX, the AJAX UI for those modules can be disabled.',
    'LBL_CONFIG_AJAX_HELP' => 'Drag and drop the names of the modules below to enable or disable the use of the AJAX UI in those modules.',
    'LBL_CONFIG_TABS' => 'Display Modules and Subpanels',
    'LBL_CONFIG_TABS_DESC' => 'Drag and Drop the names of the modules below to set them to be displayed or hidden in the top navigation bar or as subpanels. To control access to modules, use <a href="?module=ACLRoles&action=index">Role Management.</a>',
    'LBL_CONFIG_LANGS_DESC' => 'Drag and Drop the names of the languages below to enable and disable them.',
    'LBL_CONFIG_TABS_ALLOW_USERS_HIDE_TABS_HELP' => 'Select this option to allow users to choose which module tabs they can view. When selected, users will be able to choose which module tabs are visible by managing the tabs within their User Settings.',
    'LBL_CONFIGURE_GROUP_TABS_DESC' => 'Create and edit module menu filters',
    'LBL_CONFIGURE_GROUP_TABS' => 'Configure Module Menu Filters',
    'LBL_CONFIGURE_SETTINGS_TITLE' => 'System Settings',
    'LBL_CONFIGURE_SETTINGS' => 'Configure system-wide settings',
    'LBL_CONFIGURE_TABS_AND_SUBPANELS' => 'Display Modules and Subpanels',
    'LBL_COULD_NOT_CONNECT' => 'Error: Could not connect to the SuiteCRM Server.
	Please check your Proxy Settings value in the <a href="index.php?module=Configurator&action=EditView">System Settings</a> admin panel.
	 Last attempted connection @ ',
    'LBL_CREATE_RESOTRE_FILE' => 'restoreExpand.sql file was successfully created. Please use this file to revert column changes.',
    'LBL_CURRENCY' => 'Set up currencies and conversion rates',
    'LBL_CONNECTOR_SETTINGS' => 'Connectors',
    'LBL_CONNECTOR_SETTINGS_DESC' => 'Manage connector settings',
    'LBL_DENY' => 'Deny',
    'LBL_DIAG_CANCEL_BUTTON' => 'Cancel',
    'LBL_DIAG_EXECUTE_BUTTON' => 'Execute Diagnostic',
    'LBL_DIAGNOSTIC_ACCESS' => 'You must be an administrator to run the diagnostic tool.',
    'LBL_DIAGNOSTIC_BEANLIST_DESC' => 'This information tells us whether or not the beanFiles specified in the beanList actually exists. This can be an issue with an improperly defined module loaded extension.',
    'LBL_DIAGNOSTIC_BEANLIST_GREEN' => 'Green means the file does exist.',
    'LBL_DIAGNOSTIC_BEANLIST_ORANGE' => 'Orange means there is no indexed file, so we cannot look it up.',
    'LBL_DIAGNOSTIC_BEANLIST_RED' => 'Red means the file does not exist.',
    'LBL_DIAGNOSTIC_BLBF' => 'BeanList/BeanFiles files exist',
    'LBL_DIAGNOSTIC_CALCMD5' => '&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;Copy MD5 Calculated array',
    'LBL_DIAGNOSTIC_CONFIGPHP' => 'SuiteCRM config.php',
    'LBL_DIAGNOSTIC_CUSTOMDIR' => 'SuiteCRM Custom directory',
    'LBL_DIAGNOSTIC_DELETED' => 'File has been deleted',
    'LBL_DIAGNOSTIC_DELETELINK' => 'Delete the Diagnostic file',
    'LBL_DIAGNOSTIC_FILE' => 'File',
    'LBL_DIAGNOSTIC_ZIP' => '.zip doesn\'t exist.<BR><BR>',
    'LBL_DIAGNOSTIC_DELETE_ERROR' => 'Did not receive a filename or guid path to delete the file<BR><BR>',
    'LBL_DIAGNOSTIC_DELETE_DIE' => 'You are trying to delete a non diagnostic file.',
    'LBL_DIAGNOSTIC_DELETE_RETURN' => 'Return to Administration page',
    'LBL_DIAGNOSTIC_DESC' => 'Capture system configuration for diagnostics and analysis',
    'LBL_DIAGNOSTIC_DONE' => 'Done',
    'LBL_DIAGNOSTIC_DOWNLOADLINK' => 'Download the Diagnostic file',
    'LBL_DIAGNOSTIC_EXECUTING' => 'Executing Diagnostic Operations...',
    'LBL_DIAGNOSTIC_FILESMD5' => '&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;Copy files.md5',
    'LBL_DIAGNOSTIC_GETBEANFILES' => 'Checking that bean files exist...',
    'LBL_DIAGNOSTIC_GETCONFPHP' => 'Getting config.php...',
    'LBL_DIAGNOSTIC_GETCUSTDIR' => 'Getting custom dir...',
    'LBL_DIAGNOSTIC_GETMD5INFO' => 'Getting md5 information...',
    'LBL_DIAGNOSTIC_GETMYSQLINFO' => 'Database info',
    'LBL_DIAGNOSTIC_GETMYSQLTD' => 'Database dumps',
    'LBL_DIAGNOSTIC_GETMYSQLTS' => 'Database schema',
    'LBL_DIAGNOSTIC_GETPHPINFO' => 'Getting phpinfo()',
    'LBL_DIAGNOSTIC_GETSUITELOG' => 'Getting suitecrm.log',
    'LBL_DIAGNOSTIC_GETTING' => 'Getting...',
    'LBL_DIAGNOSTIC_MD5' => 'MD5 info',
    'LBL_DIAGNOSTIC_MYSQLDUMPS' => 'Configuration Table Dumps',
    'LBL_DIAGNOSTIC_MYSQLINFO' => 'General Information',
    'LBL_DIAGNOSTIC_MYSQLSCHEMA' => 'All Tables Schema',
    'LBL_DIAGNOSTIC_NO_MYSQL' => 'You do not have MySQL. The MySQL functions in have been disabled.',
    'LBL_DIAGNOSTIC_PHPINFO' => 'Output from phpinfo()',
    'LBL_DIAGNOSTIC_SUITELOG' => 'SuiteCRM Log File',
    'LBL_DIAGNOSTIC_TITLE' => 'Diagnostic Tool',
    'LBL_DIAGNOSTIC_VARDEFS' => 'SuiteCRM schema output (VARDEFS)',
    'LBL_DISABLED' => 'Disabled',
    'LBL_DISPLAY_TABS' => 'Display Tabs',
    'LBL_DO_OVERWRITE_FILES' => 'Do Not Overwrite Files',
    'LBL_DONE' => 'Done',
    'LBL_DROP_HERE' => '[Drop Here]',
    'LBL_DROPDOWN_EDITOR' => 'Dropdown Editor',
    'LBL_DST_UPGRADE' => 'Upgrade:',
    'LBL_EDIT_TABS' => 'Edit Tabs',
    'LBL_EMAIL_TITLE' => 'Email',
    'LBL_EMAIL_DESC' => 'Manage outbound and inbound emails. The email settings must be configured in order to enable users to send out email and newsletter campaigns.',
    'LBL_EMAIL_ADDRESS_REQUIRED_FOR_FEATURE' => 'A primary email address is required for each user in order to use this feature.',
    'LBL_ENABLED' => 'Enabled',
    'LBL_EXECUTE' => 'Execute',
    'LBL_EXPAND_DATABASE_COLUMNS_DESC' => 'Expands certain char, varchar and text columns in database (MSSQL ONLY)',
    'LBL_EXPAND_DATABASE_COLUMNS' => 'Expand Column Width',
    'LBL_EXPAND_DATABASE_TEXT' => 'This tool allows you to expand selected database columns as an interim fix for multi-byte character limitations in SQL Server. <br>You may choose from three options: <br>Display SQL will display the sql that will be executed on the screen<br> Export SQL will export the sql to a file<br> Execute SQL will execute the SQL.',
    'LBL_EXPORT_CUSTOM_FIELDS_TITLE' => 'Export Custom Fields Structure',
    'LBL_EXPORT_CUSTOM_FIELDS' => 'Export custom field definitions to a .sugar file',
    'LBL_EXTERNAL_DEV_DESC' => 'Migrate custom field structures from one system to another',
    'LBL_EXTERNAL_DEV_TITLE' => 'Migrate Custom Fields',
    'LBL_GLOBAL_SEARCH_SETTINGS' => 'Global Search',
    'LBL_GLOBAL_SEARCH_SETTINGS_DESC' => 'Configure the global search options for the system',
    'LBL_GO' => 'Go',
    'LBL_HELP_BOOKMARK' => 'Bookmark this page',
    'LBL_HELP_EMAIL' => 'Email',
    'LBL_HELP_PRINT' => 'Print',
    'LBL_HIDE_TABS' => 'Hide Tabs',
    'LBL_HIDDEN_PANELS' => 'Hidden Subpanels',
    'LBL_HIDDEN_TABS' => 'Hidden Modules',
    'LBL_HIDE_ADVANCED_OPTIONS' => 'Hide Advanced Options',
    'LBL_HT_DONE' => '--- DONE ---',
    'LBL_HT_NO_WRITE_2' => 'If you want to secure your files from being accessible via browser, create an .htaccess file in your root directory with the lines:',
    'LBL_HT_NO_WRITE' => 'Cannot write to the file: ',
    'LBL_ICF_DROPPING' => 'Dropping - Custom Fields Meta Data Information',
    'LBL_ICF_IMPORT_S' => 'Import Structure',
    'LBL_IFRAME' => 'My Sites',
    'LBL_IMPORT_CUSTOM_FIELDS_DESC' => ' <br>Import a .sug file that was exported from another machine. This will cause the custom field structure on this machine to match that of the other machine. It is recommended that you export your current Custom Field Structure prior to importing one. After importing the Custom Field Structure, the system will automatically run you through a Custom Field Upgrade informing you of what changes will be made to the database. If you agree with these changes click the execute non-simulation mode link at the bottom. If you wish to reverse the import process, then import the structure you exported prior to running this import. If you do <br> Warning: This will remove any previously defined custom field structures that are not defined in the .sug file as well as any data stored in those custom fields.',
    'LBL_IMPORT_CUSTOM_FIELDS_STRUCT' => ' Custom Field Structure',
    'LBL_IMPORT_CUSTOM_FIELDS_TITLE' => 'Import Custom Fields Structure',
    'LBL_IMPORT_CUSTOM_FIELDS' => 'Import custom field definitions from a .sugar file',
    'LBL_IMPORT_WIZARD' => 'Import Wizard',
    'LBL_IMPORT_WIZARD_DESC' => 'Use the import wizard to easily import records into the system',
    'LBL_LANGUAGES' => 'Manage which languages are available for users',
    'LBL_LICENSE' => 'License',

    'LBL_LDAP_TITLE' => 'LDAP Support',
    'LBL_LDAP_ENABLE' => 'Enable LDAP Authentication',
    'LBL_LDAP_HELP_TXT' => 'When LDAP authentication is enabled, passwords can only be handled through LDAP. None of the SuiteCRM Password Management feature settings will apply.',
    'LBL_LDAP_SERVER_HOSTNAME' => 'Server:',
    'LBL_LDAP_SERVER_PORT' => 'Port Number:',
    'LBL_LDAP_ADMIN_USER' => 'User Name:',
    'LBL_LDAP_ADMIN_USER_DESC' => 'Used to search for the LDAP user. This may need to be fully qualified.',
    'LBL_LDAP_ADMIN_PASSWORD' => 'Password:',
    'LBL_LDAP_AUTHENTICATION' => 'Authentication:',
    'LBL_LDAP_AUTHENTICATION_DESC' => 'Bind to the LDAP server using a specific users credentials. It will bind anonymously if not provided.',
    'LBL_LDAP_AUTO_CREATE_USERS' => 'Auto Create Users:',
    'LBL_LDAP_USER_DN' => 'User DN:',
    'LBL_LDAP_GROUP_DN' => 'Group DN:',
    'LBL_LDAP_GROUP_DN_DESC' => 'Example: <em>ou=groups,dc=example,dc=com</em>',
    'LBL_LDAP_USER_FILTER' => 'User Filter:',
    'LBL_LDAP_GROUP_MEMBERSHIP' => 'Group Membership:',
    'LBL_LDAP_GROUP_MEMBERSHIP_DESC' => 'Users must be a member of a specific group',
    'LBL_LDAP_GROUP_USER_ATTR' => 'User Attribute:',
    'LBL_LDAP_GROUP_USER_ATTR_DESC' => 'The unique identifier of the person that will be used to check if they are a member of the group Example: <em>uid</em>',
    'LBL_LDAP_GROUP_ATTR_DESC' => 'The attribute of the Group that will be used to filter against the User Attribute Example: <em>memberUid</em>',
    'LBL_LDAP_GROUP_ATTR' => 'Group Attribute:',
    'LBL_LDAP_GROUP_ATTR_REQ_DN' => 'With User DN:',
    'LBL_LDAP_GROUP_ATTR_REQ_DN_DESC' => 'Include the User DN with the User Attribute when checking group membership',
    'LBL_LDAP_USER_FILTER_DESC' => 'Any additional filter params to apply when authenticating users e.g.\\nis_suitecrm_user=1 or (is_suitecrm_user=1)(is_sales=1)',
    'LBL_LDAP_LOGIN_ATTRIBUTE' => 'Login Attribute:',
    'LBL_LDAP_BIND_ATTRIBUTE' => 'Bind Attribute:',
    'LBL_LDAP_BIND_ATTRIBUTE_DESC' => 'For Binding the LDAP User<br>Examples:&nbsp;<b>AD:</b>&nbsp;userPrincipalName,&nbsp;<b>openLDAP:</b>&nbsp;dn,&nbsp;<b>Mac&nbsp;OS&nbsp;X:</b>&nbsp;uid ',
    'LBL_LDAP_LOGIN_ATTRIBUTE_DESC' => 'For searching for the LDAP User<br>Examples:<b>AD:</b>&nbsp;userPrincipalName,&nbsp;<b>openLDAP:</b>&nbsp;cn,&nbsp;<b>Mac&nbsp;OS&nbsp;X:</b>&nbsp;dn ',
    'LBL_LDAP_SERVER_HOSTNAME_DESC' => 'Example: ldap.example.com or ldaps://ldap.example.com for SSL',
    'LBL_LDAP_SERVER_PORT_DESC' => 'Example: 389 or 636 for SSL',
    'LBL_LDAP_GROUP_NAME' => 'Group Name:',
    'LBL_LDAP_GROUP_NAME_DESC' => 'Example cn=SuiteCRM',
    'LBL_LDAP_USER_DN_DESC' => 'Example: ou=people,dc=example,dc=com',
    'LBL_LDAP_AUTO_CREATE_USERS_DESC' => 'If an authenticated user does not exist, one will be created in SuiteCRM.',
    'LBL_LDAP_ENC_KEY' => 'Encryption Key:',

    'LBL_LOADING' => 'Loading, Please wait...',
    'LBL_LOCALE_DB_COLLATION_TITLE' => 'Database Collation',
    'LBL_LOCALE_DB_COLLATION' => 'Collation',
    'LBL_LOCALE_DEFAULT_CURRENCY_ISO4217' => 'ISO 4217 Currency Code',
    'LBL_LOCALE_DEFAULT_CURRENCY_NAME' => 'Currency',
    'LBL_LOCALE_DEFAULT_CURRENCY_SYMBOL' => 'Currency Symbol',
    'LBL_LOCALE_DEFAULT_CURRENCY' => 'System Currency',
    'LBL_LOCALE_DEFAULT_DATE_FORMAT' => 'Date Format',
    'LBL_LOCALE_DEFAULT_DECIMAL_SEP' => 'Decimal Symbol',
    'LBL_LOCALE_DEFAULT_LANGUAGE' => 'Language',
    'LBL_LOCALE_DEFAULT_NAME_FORMAT' => 'Name Format',
    'LBL_LOCALE_DEFAULT_NUMBER_GROUPING_SEP' => '1000s Separator',
    'LBL_LOCALE_DEFAULT_SYSTEM_SETTINGS' => 'User Interface',
    'LBL_LOCALE_DEFAULT_TIME_FORMAT' => 'Time Format',
    'LBL_LOCALE_EXAMPLE_NAME_FORMAT' => 'Example',
    'LBL_LOCALE_NAME_FORMAT_DESC' => '"s" Salutation<br>"f" First Name<br>"l" Last Name',
    'LBL_LOCALE_TITLE' => 'System Locale Settings',
    'LBL_LOCALE' => 'Set default localization settings for your system',
    'LBL_MAILBOX_DESC' => 'Set up group mail accounts for monitoring inbound email and manage personal inbound mail account information for users',
    'LBL_MAILBOX_OUTBOUND_DESC' => 'Configure outbound email settings',
    'LBL_MANAGE_CURRENCIES' => 'Currencies',
    'LBL_MANAGE_LANGUAGES' => 'Languages',
    'LBL_MANAGE_LICENSE_TITLE' => 'License Management',
    'LBL_MANAGE_LICENSE' => 'Manage license properties',
    'LBL_MANAGE_LOCALE' => 'Locale',
    'LBL_MANAGE_MAILBOX' => 'Inbound Email',
    'LBL_MANAGE_MAILBOX_OUTBOUND' => 'Outbound Email',
    'LBL_MANAGE_PASSWORD_TITLE' => 'Password Management',
    'LBL_MANAGE_PASSWORD' => 'Manage password requirements and expiration',
    'LBL_MANAGE_RELEASES' => 'Releases',
    'LBL_MANAGE_ROLES_TITLE' => 'Role Management',
    'LBL_MANAGE_ROLES' => 'Manage role membership and properties',
    'LBL_MANAGE_USERS_TITLE' => 'User Management',
    'LBL_MANAGE_USERS' => 'Manage user accounts and passwords',
    'LBL_MASS_EMAIL_CONFIG_DESC' => 'Configure email settings',
    'LBL_MASS_EMAIL_CONFIG_TITLE' => 'Email Settings',
    'LBL_MASS_EMAIL_MANAGER_DESC' => 'Manage the outbound email queue',
    'LBL_MASS_EMAIL_MANAGER_TITLE' => 'Email Queue',

    //ModuleInstaller
    'LBL_MI_REBUILDING' => 'Rebuilding',
    'LBL_MI_IN_EXT' => 'Installing %s extension',
    'LBL_MI_UN_EXT' => 'Uninstalling %s extension',
    'LBL_MI_UN_CUSTOMFIELD' => 'Uninstalling Custom Fields...',
    'LBL_MI_IN_CUSTOMFIELD' => 'Installing Custom Fields...',
    'LBL_MI_COMPLETE' => 'Complete',
    'LBL_MI_UN_BEAN' => 'Uninstalling Bean :',
    'LBL_MI_IN_BEAN' => 'Installing Bean :',
    'LBL_MI_IN_DASHLETS' => 'Installing SuiteCRM Dashlet ',
    'LBL_MI_UN_DASHLETS' => 'Uninstalling SuiteCRM Dashlet ',
    'LBL_MI_IN_IMAGES' => 'Installing Images',
    'LBL_MI_IN_MENUS' => 'Installing menus',
    'LBL_MI_UN_MENUS' => 'Uninstalling menus',
    'LBL_MI_IN_LANG' => 'Installing Language Packs',
    'LBL_MI_UN_LANG' => 'Uninstalling Language Packs',
    'LBL_MI_IN_RELATIONSHIPS' => 'Installing Relationships',
    'LBL_MI_UN_RELATIONSHIPS' => 'Uninstalling Relationships',
    'LBL_MI_UN_RELATIONSHIPS_DROP' => 'droping table ',
    'LBL_MI_REPAIR_INDICES' => 'Repairing indexes',
    'LBL_MI_IN_CONNECTORS' => 'Installing Connectors',
    'LBL_MI_UN_CONNECTORS' => 'Uninstalling Connectors',
    'LBL_ML_ACTION' => 'Action',
    'LBL_ML_CANCEL' => 'Cancel',
    'LBL_ML_COMMIT' => 'Commit',
    'LBL_ML_DESCRIPTION' => 'Description',
    'LBL_ML_INSTALLED' => 'Date Installed',
    'LBL_ML_NAME' => 'Name',
    'LBL_ML_PUBLISHED' => 'Date Published',
    'LBL_ML_TYPE' => 'Type',
    'LBL_ML_UNINSTALLABLE' => 'Uninstallable',
    'LBL_ML_VERSION' => 'Version',
    'LBL_ML_INSTALL' => 'Install',
    'LBL_ML_ENABLE_OR_DISABLE' => 'Enable/Disable',
    'LBL_ML_DELETE' => 'Delete',
    'LBL_MODIFY_CREDENTIALS' => 'Modify Credentials',
    'LBL_MODULE_LICENSE' => 'Please read the following License Agreement:',
    'LBL_MODULE_LOADER_TITLE' => 'Module Loader',
    'LBL_MODULE_LOADER' => 'Add or remove SuiteCRM modules, themes, language packs and other extensions',
    'LBL_MODULE_NAME' => 'Administration',
    'LBL_MODULE_TITLE' => 'Administration: Home',
    'LBL_NEVER' => 'Never',
    'LBL_NEW_FORM_TITLE' => 'Create Account',
    'LBL_NOTIFY_SUBJECT' => 'Email subject:',
    'LBL_OVERWRITE_FILES' => 'Overwrite Files',
    'LBL_PASSWORD' => 'Password',
    'LBL_PASSWORD_TEMPLATE' => 'Email Templates',
    'LBL_PASSWORD_CREATE_TEMPLATE' => 'Create',
    'LBL_PASSWORD_EDIT_TEMPLATE' => 'Edit',
    'LBL_PASSWORD_GENERATE_TEMPLATE_MSG' => 'For system-generated password',
    'LBL_PASSWORD_LOST_TEMPLATE_MSG' => 'For system-generated link to reset password',
    'LBL_TWO_FACTOR_AUTH_EMAIL_TPL' => 'For system-generated two-factor authentication code',
    'LBL_PASSWORD_SYST_GENERATED_PWD_ON' => 'Enable System-Generated Passwords Feature',
    'LBL_PASSWORD_SYST_GENERATED_PWD_HELP' => 'When this feature is enabled, users will be emailed a system-generated link to reset their passwords. Requirements for this feature are: 1) a outbound email server must be configured properly in Email Settings, and 2) users must have valid email addresses in their user records',
    'LBL_PASSWORD_EXP_AFTER' => 'Password Expires upon',
    'LBL_PASSWORD_FORGOT_FEATURE' => 'Enable Forgot Password feature',
    'LBL_PASSWORD_FORGOT_FEATURE_HELP' => 'When enabled, users will have the ability to reset their own passwords at the Login page. Requirements to use this feature: 1) users must have email addresses provided in their user records, and 2) an outbound email server must be configured in the Email Settings page.',
    'LBL_PASSWORD_LOGINS' => 'logins',
    'LBL_PASSWORD_SYST_EXPIRATION' => 'System-Generated Password Expiration',
    'LBL_PASSWORD_SYST_GENERATED_TITLE' => 'System-Generated Passwords',
    'ERR_PASSWORD_LINK_EXPIRE_TIME' => 'Specify the time after which the generated link will expire.',
    'ERR_PASSWORD_EXPIRE_TIME' => 'Specify the time after which the password will expire.',
    'ERR_PASSWORD_EXPIRE_LOGIN' => 'Specify the number of logins after which the password will expire.',
    'LBL_PASSWORD_LINK_EXPIRATION' => 'Generated Link Expiration',
    'LBL_PASSWORD_LINK_EXPIRATION_HELP' => 'A link is generated by the system and sent to the user to allow the user to access the Reset Password page.',
    'LBL_PASSWORD_LINK_EXP_IN' => 'Link Expires in',
    'LBL_PASSWORD_EXP_IN' => 'Password Expires in',
    'LBL_PASSWORD_USER_RESET' => 'User Reset Password',
    'LBL_PROXY_AUTH' => 'Authentication?',
    'LBL_PROXY_HOST' => 'Proxy Host',
    'LBL_PROXY_ON_DESC' => 'Use a proxy to access external information such as SuiteCRM updates.',
    'LBL_PROXY_ON' => 'Enable Proxy?',
    'LBL_PROXY_PASSWORD' => 'Password',
    'LBL_PROXY_PORT' => 'Port',
    'LBL_PROXY_TITLE' => 'Proxy Settings',
    'LBL_PROXY_USERNAME' => 'User Name',
    'LBL_README' => 'Readme',
    'LBL_REBUILD_AUDIT_SEARCH' => 'Searching for new audit enabled modules',
    'LBL_REBUILD_AUDIT_SKIP' => 'Audit table for %1$s already exists. skipping...<BR>',
    'LBL_REBUILD_CONFIG_DESC' => 'Rebuilds config.php by updating version and adding defaults when not explicitly declared',
    'LBL_REBUILD_CONFIG' => 'Rebuild Config File',
    'LBL_REBUILD_DASHLETS_DESC_SHORT' => 'Rebuilds the SuiteCRM Dashlets cache file',
    'LBL_REBUILD_DASHLETS_DESC_SUCCESS' => 'SuiteCRM Dashlets cache file rebuilt.',
    'LBL_REBUILD_DASHLETS_DESC' => 'Removing SuiteCRM Dashlets cache and scanning known directories for SuiteCRM Dashlet files.',
    'LBL_REBUILD_DASHLETS_TITLE' => 'Rebuild SuiteCRM Dashlets',
    'LBL_REBUILD_HTACCESS_DESC' => 'Rebuilds .htaccess to limit access to certain files directly',
    'LBL_REBUILD_HTACCESS' => 'Rebuild .htaccess File',
    'LBL_REBUILD_WEBCONFIG_DESC' => 'Rebuilds web.config to limit access to certain files directly',
    'LBL_REBUILD_WEBCONFIG' => 'Rebuild web.config File',
    'LBL_REBUILD_JAVASCRIPT_LANG_DESC_SHORT' => 'Rebuilds javascript versions of language files',
    'LBL_REBUILD_JAVASCRIPT_LANG_DESC' => 'Removing javascript versions of language files, will rebuild when needed.',
    'LBL_REBUILD_JAVASCRIPT_LANG_TITLE' => 'Rebuild Javascript Languages',

    'LBL_REBUILD_JS_FILES_TITLE' => 'Rebuild JS Compressed Files',
    'LBL_REBUILD_JS_FILES_DESC_SHORT' => 'Copies original Full JS Source files and replaces existing compressed JS files',
    'LBL_REBUILD_CONCAT_JS_FILES_TITLE' => 'Rebuild JS Grouping Files',
    'LBL_REBUILD_CONCAT_JS_FILES_DESC_SHORT' => 'Re-concatenates and overwrites existing group files with latest versions of group files',
    'LBL_REBUILD_JS_MINI_FILES_TITLE' => 'Rebuild Minified JS Files',
    'LBL_REBUILD_JS_MINI_FILES_DESC_SHORT' => 'Copies original Full JS Source Files and minifies them, then replaces existing compressed files',
    'LBL_REPAIR_JS_FILES_TITLE' => 'Repair JS Files',
    'LBL_REPAIR_JS_FILES_DESC_SHORT' => 'Compresses Existing JS files - includes any changes made, but does not overwrite original JS Source files',
    'LBL_REPAIR_JS_FILES_PROCESSING' => 'Processing files. This may take several minutes. Going away from this page will not cancel the process, so feel free to move on or wait for confirmation...',
    'LBL_REPAIR_JS_FILES_DONE_PROCESSING' => 'Done Processing files.',
    'LBL_REPAIR_FIELD_CASING_TITLE' => 'Repair Non-Lowercase Fields',
    'LBL_REPAIR_FIELD_CASING_DESC_SHORT' => 'Repair mixed-case custom table(s) and metadata file(s) to fix issues where code expects lowercase field names',
    'LBL_REPAIR_FIELD_CASING_PROCESSING' => 'Scanning custom fields and files...',
    'LBL_REPAIR_FIELD_CASING_SQL_FIELD_META_DATA' => 'Updating row entry {0} in table fields_meta_data',
    'LBL_REPAIR_FIELD_CASING_SQL_CUSTOM_TABLE' => 'Updating column {0} in table {1}',
    'LBL_REBUILD_REL_DESC' => 'Rebuilds relationship metadata and drops the cache file',
    'LBL_REBUILD_REL_TITLE' => 'Rebuild Relationships',
    'LBL_REBUILD_REL_PROC_META' => 'Processing relationship meta for ',
    'LBL_REBUILD_REL_PROC_C_META' => 'Processing custom relationship meta for ',
    'LBL_REBUILD_REL_DEL_CACHE' => 'Deleting relationship cache file...<BR>',
    'LBL_REBUILD_REL_UPD_WARNING' => 'Updating the admin warning message...<BR>',
    'LBL_REBUILD_SCHEDULERS_DESC_SHORT' => 'Rebuilds out-of-the-box Scheduler Jobs',
    'LBL_REBUILD_SCHEDULERS_DESC_SUCCESS' => 'Scheduler Job rebuild complete.',
    'LBL_REBUILD_SCHEDULERS_DESC' => 'Rebuilding your Scheduler Jobs will delete all existing job entries and their respective logs. All out-of-the-box Scheduler jobs will be rebuilt with their default settings, including the Active/Inactive flag.',
    'LBL_REBUILD_SCHEDULERS_TITLE' => 'Rebuild Schedulers',
    'LBL_REBUILD_SPRITES_TITLE' => 'Rebuild Sprites',
    'LBL_REBUILD_SPRITES_DESC_SHORT' => 'Rebuilds the sprite images and configuration files',
    'LBL_REBUILD' => 'Rebuild',
    'LBL_RELEASE' => 'Manage releases and versions',
    'LBL_RENAME_TABS' => 'Rename Modules',
    'LBL_REPAIR_ACTION' => 'What action would you like to take?',
    'LBL_REPAIR_DATABASE_DESC' => 'Repairs database based on values defined in vardefs',
    'LBL_REPAIR_DATABASE_PROCESSING' => 'Processing database and vardef comparison...',
    'LBL_REPAIR_DATABASE_DIFFERENCES' => "Differences found between database and vardefs",
    'LBL_REPAIR_DATABASE_TEXT' => "The following script will sync the database structure with the structure defined in the vardefs. You have the option of exporting this script and then running it against your database using external database management tools, or to allow the administration module to run the script. <br><br><strong>NOTE</strong>: any changes you make to the script in the textbox will be reflected in the exported or executed code.<br><br>",
    'LBL_REPAIR_DATABASE_SYNCED' => "Database tables are synced with vardefs",
    'LBL_REPAIR_DATABASE_EXECUTE' => "Execute",
    'LBL_REPAIR_DATABASE_EXPORT' => "Export",
    'LBL_REPAIR_DATABASE' => 'Repair Database',
    'LBL_REPAIR_DISPLAYSQL' => 'Display SQL',
    'LBL_REPAIR_EXECUTESQL' => 'Execute SQL',
    'LBL_REPAIR_EXPORTSQL' => 'Export SQL',
    'LBL_REPAIR_IE_DESC' => 'Repairs Inbound Email accounts and encrypts account passwords',
    'LBL_REPAIR_IE_FAILURE' => 'The following Inbound Email accounts must be repaired manually - please re-enter login name and password for each:',
    'LBL_REPAIR_IE_SUCCESS' => 'All Inbound Email accounts repaired successfully!',
    'LBL_REPAIR_IE' => 'Repair Inbound Email Accounts',
    'LBL_SYNC_IE_EMAILS' => 'Sync Inbound Email Accounts',
    'LBL_SYNC_IE_EMAILS_DESC' => 'Sync Inbound Email Accounts and Emails',
    'LBL_SYNC' => 'Sync',
    'LBL_REPAIR_INDEX_DROPPING' => '<BR>Dropping constraints/indexes.',
    'LBL_REPAIR_INDEX_EXECUTING' => '<BR> Executing ',
    'LBL_REPAIR_INDEX_DROP' => '<BR>Drop these constraints/indexes.',
    'LBL_REPAIR_INDEX_ADDING' => '<BR>Adding constraints/indexes.',
    'LBL_REPAIR_INDEX_ADD' => '<BR><BR>Add these constraints/indexes.',
    'LBL_REPAIR_INDEX_ALTERING' => '<BR>Altering constraints/indexes.',
    'LBL_REPAIR_INDEX_ALTER' => '<BR><BR>Alter these constraints/indexes.',
    'LBL_REPAIR_INDEX_SYNC' => '<BR><BR><BR> Index definitions are in sync.',
    'LBL_REPAIR_ROLES_DESC' => 'Repairs Roles by adding all new modules that support Access Controls, and by adding any new Access Controls to existing modules',
    'LBL_REPAIR_ROLES' => 'Repair Roles',
    'LBL_REPAIR_XSS' => 'Remove XSS',
    'LBL_REPAIR_ACTIVITIES_DESC' => 'Repairs Activities (Calls, Meetings) end dates',
    'LBL_REPAIR_ACTIVITIES' => 'Repair Activities',

    'LBL_ALL' => 'All',
    'LBL_REPAIRXSS_COUNT' => 'Object(s) found',
    'LBL_REPAIRXSS_INSTRUCTIONS' => 'Select a module to remove potential XSS strings. Select "All" to address every module.<br>Press execute to start the detection and removal process.',
    'LBL_REPAIRXSS_REPAIRED' => 'Object(s) repaired',
    'LBL_REPAIRXSS_TITLE' => 'Removes XSS Vulnerabilities from the database',

    'LBL_RESTORE_BUTTON_LABEL' => 'Restore',
    'LBL_RETURN' => 'Return',
    'LBL_SEND_STAT' => '<B>Send Anonymous Usage Statistics</B> - If checked, it will send anonymous statistics about your installation to SuiteCRM. every time your system checks for new versions. This information will help us better understand how the application is used and guide improvements to the product.',
    'LBL_SHOW_ADVANCED_OPTIONS' => 'Show Advanced Options',
    'LBL_STATUS' => 'Status ',
    'LBL_TOOLS_DESC' => 'Create and edit modules and module layouts, manage standard and custom fields and configure tabs. ',
    'LBL_STUDIO_DESC' => 'Customize module fields, layouts and relationships',
    'LBL_STUDIO_TITLE' => 'Developer Tools',
    'LBL_STUDIO' => 'Studio',
    'LBL_SUITE_SCHEDULER_TITLE' => 'Scheduler',
    'LBL_SUITE_SCHEDULER' => 'Set up scheduled events',
    'LBL_SUITE_UPDATE_TITLE' => 'SuiteCRM Updates',
    'LBL_SYSTEM_NAME' => 'System Name',
    'LBL_TERMS_AND_CONDITIONS' => 'Terms and Conditions',
    'LBL_THEME_SETTINGS' => 'Themes',
    'LBL_THEME_SETTINGS_DESC' => 'Choose themes for users to be able to select',
    'LBL_TIMEZONE' => 'Time Zone',
    'LBL_TO' => ' to ',
    'LBL_SUITEFEED_SETTINGS' => 'Activity Stream Settings',
    'LBL_SUITEFEED_SETTINGS_DESC' => 'Enable the user feed and module feeds for the My Activity Stream dashlet',
    'LBL_UPDATE_CHECK_TYPE' => '<B>Automatically Check For Updates</B> - If checked, the system will periodically check to see if updated versions of the application are available.',
    'LBL_UPDATE_DESCRIPTIONS' => 'Description',
    'LBL_UPDATE_TITLE' => 'SuiteCRM Updates',
    'LBL_UPGRADE_TITLE' => 'Repair',
    'LBL_UPGRADE_WIZARD_TITLE' => 'Upgrade Wizard',
    'LBL_UPGRADE_WIZARD' => 'Upload and install SuiteCRM upgrades',
    'LBL_UPGRADE' => 'Check and repair SuiteCRM',
    'LBL_UPLOAD_UPGRADE' => 'Upload an upgrade: ',
    'LBL_UPTODATE' => 'You have the latest version available',
    'LBL_USER_NAME' => 'User Name:',
    'LBL_USERNAME' => 'User Name',
    'LBL_USERS_TITLE' => 'Users & Authentication',
    'LBL_HISTORY_CONTACTS_EMAILS' => 'History Subpanel',
    'LBL_HISTORY_CONTACTS_EMAILS_DESC' => 'Enable/Disable contacts\' emails in history',

    'LBL_USERS_DESC' => 'Create, edit, activate and deactivate users in SuiteCRM.',


    'LBL_UW_BTN_BACK_TO_MOD_LOADER' => 'Back to Module Loader',
    'LBL_UW_BTN_BACK_TO_UW' => 'Back to Upgrade Wizard',
    'LBL_UW_BTN_DELETE_PACKAGE' => 'Delete Package',
    'LBL_UW_BTN_DOWNLOAD' => 'Download',
    'LBL_UW_BTN_INSTALL' => 'Install',
    'LBL_UW_BTN_UPLOAD' => 'Upload',
    'LBL_UW_CHECK_ALL' => 'Check All',
    'LBL_UW_DESC_MODULES_INSTALLED' => 'The following extensions are installed on this system:',
    'LBL_UW_DESC_MODULES_QUEUED' => 'The following modules are ready to be installed:',
    'LBL_UW_DISABLE' => 'Disable',
    'LBL_UW_ENABLE' => 'Enable',
    'LBL_UW_FOLLOWING_FILES' => 'The following files were ',
    'LBL_UW_HIDE_DETAILS' => 'Hide Details',
    'LBL_UW_INCLUDING' => 'Including',
    'LBL_UW_LANGPACK_READY_DISABLE' => 'The language package is ready to be disabled.',
    'LBL_UW_LANGPACK_READY_ENABLE' => 'The language package is ready to be enabled.',
    'LBL_UW_LANGPACK_READY_UNISTALL' => 'The language package is ready to be uninstalled.',
    'LBL_UW_LANGPACK_READY' => 'The language package is ready to be installed.',
    'LBL_UW_NO_FILES_SELECTED' => 'No files selected to be ',
    'LBL_UW_NO_INSTALLED_UPGRADES' => "<i>No recorded upgrades.</i><br>\n",
    'LBL_UW_NONE' => 'None',
    'LBL_UW_OP_MODE' => 'Mode of operation:',
    'LBL_UW_PATCH_READY' => '<h2>Ready To Install</h2>',
    'LBL_UW_UNINSTALL_READY' => '<h2>Ready To Uninstall</h2>',
    'LBL_UW_DISABLE_READY' => '<h2>Ready To Disable</h2>',
    'LBL_UW_ENABLE_READY' => '<h2>Ready To Enable</h2>',
    'LBL_UW_SHOW_DETAILS' => 'Show Details',
    'LBL_UW_SUCCESSFUL' => 'Successful',
    'LBL_UW_SUCCESSFULLY' => 'Successfully',
    'LBL_UW_UNINSTALL' => 'Uninstall',
    'LBL_UW_UPGRADE_SUCCESSFUL' => "<b>Upgrade applied successfully!</b><br>\n",
    'LBL_UW_UPLOAD_MODULE' => 'Module',
    'LBL_UW_TYPE_THEME' => 'Theme',
    'LBL_UW_UPLOAD_SUCCESS' => " has been uploaded.<br>",
    'LBL_VISIBLE_PANELS' => 'Displayed Subpanels',
    'LBL_VISIBLE_TABS' => 'Displayed Modules',

    'LNK_FORGOT_PASS' => 'Forgotten your password?',
    'LNK_NEW_ACCOUNT' => 'Create an account',
    'LNK_NEW_USER' => 'Create New User',
    'LNK_NEW_GROUP_USER' => 'Create New Group User',
    'MI_REDIRECT_TO_UPGRADE_WIZARD' => 'Selecting this patch will redirect you to the Upgrade Wizard to perform the necessary system checks. Do you wish to continue?',
    'ML_DESC_DOCUMENTATION' => 'Click on a tree node to view the associated details and documentation.',
    'ML_LBL_DETAIILS' => 'Details',
    'ML_LBL_DO_NOT_REMOVE_TABLES' => 'Do Not Remove Tables',
    'ML_LBL_OVERWRITE_FILES' => 'Since your last action with this module the following files have changed. What action would you like to take?',
    'ML_LBL_REMOVE_TABLES' => 'Remove Tables',
    'ML_LBL_REVIEWS' => 'Reviews',
    'ML_LBL_SCREENSHOTS' => 'Screenshots',
    'MSG_CONFIG_FILE_READY_FOR_REBUILD' => 'The config.php file is ready for rebuild.',
    'MSG_CONFIG_FILE_REBUILD_FAILED' => 'The config.php could not be rebuilt.',
    'MSG_CONFIG_FILE_REBUILD_SUCCESS' => 'The config.php was successfully rebuilt.',
    'MSG_INCREASE_UPLOAD_MAX_FILESIZE' => 'Warning: Your PHP configuration must be changed to allow files of at least 6MB to be uploaded. Please modify the upload_max_filesize value in your php.ini located at:',
    'MSG_MAKE_CONFIG_FILE_WRITABLE' => 'Please make the config.php writable and try again.',
    'MSG_REBUILD_EXTENSIONS' => 'Please go to the <a href="index.php?module=Administration&action=Upgrade">Repair</a> screen and click on Rebuild Extensions.',
    'MSG_REBUILD_RELATIONSHIPS' => 'Please go to the <a href="index.php?module=Administration&action=Upgrade">Repair</a> screen and click on Rebuild Relationships.',
    'REMOVE_QUESTION' => 'Are you sure you wish to remove the selected package?',
    'WARN_POSSIBLE_JS_OVERWRITE' => 'Caution, this will overwrite any changes you may have made to javascript files, would you like to proceed?',
    'WARN_INSTALLER_LOCKED' => 'Warning: To safeguard your data, the installer must be locked by setting \'installer_locked\' to \'true\' in the config.php file.',
    'WARN_UPGRADE' => 'Warning: Please upgrade ',
    'WARN_UPGRADE2' => ' using the upgrade in the <a href="index.php?module=Administration&action=Upgrade">administration panel</a>',
    'WARN_NO_SMTP_SERVER_AVAILABLE_ERROR' => "Note: To send record assignment notifications, an SMTP server must be configured in <a href='index.php?module=EmailMan&action=config'>Email Settings</a>.",
    'LBL_MODULEBUILDER' => 'Module Builder',
    'LBL_MODULEBUILDER_DESC' => 'Build new modules to expand the functionality of SuiteCRM',
    'LBL_SUITEPORTAL' => 'SuiteCRM Portal',
    'LBL_CLEAR_VARDEFS_DATA_CACHE_TITLE' => 'Clear Vardefs Data Cache',
    'LBL_QUICK_REPAIR_AND_REBUILD' => 'Quick Repair and Rebuild',
    'LBL_QUICK_REPAIR_TITLE' => 'Please select Module(s) to repair:',
    'LBL_QUICK_REPAIR_AND_REBUILD_DESC' => 'Repairs and rebuilds DB, Extensions, Vardefs, SuiteCRM Dashlets etc.',
    'LBL_ALL_MODULES' => 'All Modules',
    'LBL_CAMPAIGN_CONFIG_TITLE' => 'Campaign Email Settings',
    'LBL_CAMPAIGN_CONFIG_DESC' => 'Configure email settings for campaigns',
    'LBL_REPAIR_ORACLE_FULLTEXT' => 'Rebuild fulltext indices',
    'LBL_REPAIR_ORACLE_FULLTEXT_DESC' => 'Triggers a rebuild of fulltext indices. Oracle 9i owners should run this frequently.',
    'LBL_REPAIR' => 'Repair',
    'LBL_QR_CBOX_DATAB' => 'Repair Database',
    'LBL_QR_CBOX_CLEARTPL' => 'Clear .tpl Files',
    'LBL_QR_CBOX_CLEARJS' => 'Clear Javascript Files',
    'LBL_QR_CBOX_CLEARVARDEFS' => 'Clear Vardefs',
    'LBL_QR_CBOX_CLEARJSLANG' => 'Clear Javascript Language Files',
    'LBL_QR_CBOX_CLEARDASHLET' => 'Clear SuiteCRM Dashlet Cache Data',
    'LBL_QR_CBOX_REBUILDAUDIT' => 'Rebuild Audit Tables',
    'LBL_QR_CBOX_REBUILDEXT' => 'Rebuild Extensions',
    'LBL_QR_CBOX_CLEARLANG' => 'Clear Language Files',
    'LBL_QR_CBOX_CLEARSEARCH' => 'Clear Unified Search Cache',
    'LBL_QR_REBUILDEXT' => '<h3> Rebuilding Extensions...</h3>',
    'LBL_QR_CLEARSMARTY' => 'Clearing Smarty templates from cache...done',
    'LBL_QR_XMLFILES' => 'Clearing XML files from cache...done',
    'LBL_QR_CLEARDASHLET' => 'Clearing SuiteCRM Dashlet files from cache...done',
    'LBL_QR_CLEARTEMPLATE' => 'Clearing Template files from cache...done',
    'LBL_QR_CLEARVADEFS' => 'Clearing Vardefs from cache...done',
    'LBL_QR_CLEARJS' => 'Clearing JS files from cache...done',
    'LBL_QR_CLEARJSLANG' => 'Clearing JS Language files from cache...done',
    'LBL_QR_CLEARLANG' => 'Clearing language files from cache...done',
    'LBL_QR_CLEARSEARCH' => 'Clearing Unified Search Cache...done',
    'LBL_QR_REBUILDAUDIT' => 'Rebuilding Audit Tables...',
    'LBL_QR_CBOX_CLEARSUITEFEEDCACHE' => 'Clear SuiteCRM Feed Cache',
    'LBL_QR_CLEARSUITEFEEDCACHE' => 'Clearing SuiteCRM Feed Cache...done',
    'LBL_QR_CBOX_CLEARTHEMECACHE' => 'Clear Theme Cache',
    'LBL_QR_CLEARTHEMECACHE' => 'Clearing Theme Cache...done',
    'LBL_REPAIR_DB_FOR' => 'Repairing DB for',
    'LBL_QR_CREATING_TABLE' => 'creating table',
    'LBL_QR_NOT_AUDIT_ENABLED' => ' not Audit Enabled...<br/>',
    'LBL_FOR' => 'for',
    'LBL_QR_CBOX_CLEARPDFFONT' => 'Clear PDF Font Cache File',
    'LBL_QR_CLEAR_EXT_API' => 'Clearing External API Cache File...done',
    'LBL_REPAIR_SEED_USERS_TITLE' => 'Enable/Disable Seed Users',
    'LBL_REPAIR_SEED_USERS_ACTIVATE' => 'Activate',
    'LBL_REPAIR_SEED_USERS_DECACTIVATE' => 'Deactivate',
    'LBL_REPAIR_SEED_USERS_DESC' => 'Quickly enable or disable seed users populated during demo installation.',
    'LBL_UW_FILES_REMOVED' => "These files will be removed from the system:<br>\n",

    'LBL_MODULE_UPLOAD_DISABLE_HELP_TEXT' => 'New uploads for Module Loader are disabled. Installable modules are restricted to the modules pre-loaded below.',

    'ML_PACKAGE_SCANNING' => 'Scanning {PACKAGE}',
    'ML_INSTALLATION_FAILED' => 'Installation failed!',
    'ML_RELAX_LOCAL' => 'If you are running SuiteCRM locally, you can relax your Module Loader restrictions to allow the package to be installed.',
    'ML_SUITE_KB' => 'SuiteCRM Knowledge Base',
    'ML_SUITE_DZ' => 'SuiteCRM Developer Zone',
    'ML_AVAIL_RESTRICTION' => 'The available restrictions and exceptions are detailed in the',
    'ML_OVERRIDE_CORE_FILES' => 'Overriding of core SuiteCRM files is not allowed ',
    'ML_PATH_MAY_NOT_CONTAIN' => 'File path may not contain',
    'ML_INVALID_ACTION_IN_MANIFEST' => 'Invalid action in your manifest:',
    'ML_NO_MANIFEST' => 'This package does not contain a manifest',
    'ML_INVALID_FUNCTION' => 'Invalid usage of a function ',
    'ML_INVALID_METHOD' => 'Invalid usage of a reserved method name ',
    'ML_INVALID_EXT' => 'Invalid file extension ',
    'ML_ISSUES' => 'Issues',
    'ML_MANIFEST_ISSUE' => 'Issue with the manifest',
    'ML_CONFIG_OVERRIDE' => 'Config modification is not allowed',

    'LBL_ACTIVE_MODULES' => 'Enabled Modules',
    'LBL_DISABLED_MODULES' => 'Disabled Modules',
    'LBL_SAVING' => 'Saving...',
    'DEFAULT_THEME' => 'Default theme',
    'LBL_ENABLED_LANGS' => 'Enabled Languages',
    'LBL_DISABLED_LANGS' => 'Disabled Languages',

    //language changed
    'LBL_CURRENT_LANGUAGE_CHANGE' => 'Your current language is changed to ',
    'LBL_DEFAULT_LANGUAGE_CHANGE' => 'System\'s default language is changed to ',
    'ACLRoles' => 'ACLRole',
    'Administration' => 'Administration',
    'Audit' => 'Audit',
    'CampaignTrackers' => 'CampaignTracker',
    'Connectors' => 'Connectors',
    'ContractTypes' => 'ContractType',
    'Currencies' => 'Currency',
    'CustomFields' => 'CustomFields',
    'CustomQueries' => 'CustomQuery',
    'DataSets' => 'DataSet',
    'DocumentRevisions' => 'DocumentRevision',
    'DynamicFields' => 'DynamicField',
    'EditCustomFields' => 'FieldsMetaData',
    'EmailMan' => 'EmailMan',
    'Employees' => 'Employee',
    'Expressions' => 'Expression',
    'Feeds' => 'Feed',
    'ForecastOpportunities' => 'ForecastOpportunities',
    'ForecastSchedule' => 'ForecastSchedule',
    'Groups' => 'Group',
    'Holidays' => 'Holiday',
    'Import_1' => 'ImportMap',
    'Import_2' => 'UsersLastImport',
    'InboundEmail' => 'InboundEmail',

    'Manufacturers' => 'Manufacturer',
    'ProductBundleNotes' => 'ProductBundleNote',
    'ProductBundles' => 'ProductBundle',
    'ProjectResources' => 'ProjectResource',

    'Relationships' => 'Relationship',
    'Releases' => 'Release',
    'ReportMaker' => 'Advanced Reports',
    'Roles' => 'Role',
    'Schedulers' => 'Scheduler',
    'SchedulersJobs' => 'SchedulersJob',
    'Shippers' => 'Shipper',
    'TaxRates' => 'TaxRate',
    'TeamMemberships' => 'TeamMembership',
    'TeamNotices' => 'TeamNotice',
    'TeamSets' => 'TeamSet',
    'TimePeriods' => 'TimePeriod',
    'TrackerPerfs' => 'TrackerPerf',
    'TrackerQueries' => 'TrackerQuery',
    'TrackerSessions' => 'TrackerSession',
    'UserPreferences' => 'UserPreference',
    'Versions' => 'Version',
    'WorkFlowActions' => 'WorkFlowAction',
    'WorkFlowActionShells' => 'WorkFlowActionShell',
    'WorkFlowAlerts' => 'WorkFlowAlert',
    'WorkFlowAlertShells' => 'WorkFlowAlertShell',
    'WorkFlowTriggerShells' => 'WorkFlowTriggerShell',
    'Worksheet' => 'Worksheet',
    'LBL_SAML_ENABLE' => 'Enable SAML Authentication',
    'LBL_SAML_HELP_TXT' => 'When SAML authentication is enabled, passwords can only be handled through SAML. None of the SuiteCRM Password Management feature settings will apply.',
    'LBL_SAML_TITLE' => 'SAML Authentication',
    'LBL_SAML_CERT' => 'X509 Certificate',
    'LBL_SAML_CERT_DESC' => 'Enter X509 Certificate',
    'LBL_SAML_LOGIN_URL' => 'Login URL', //SAML Authentication
    'LBL_SAML_LOGOUT_URL' => 'SLO URL', //SAML Single Log-out
    'LBL_SAML_LOGIN_URL_DESC' => 'Enter Login URL',
    'LBL_SAML_LOGOUT_URL_DESC' => 'Enter Logout URL',

    'LBL_SELECT_MODULES' => 'Advanced',
    'LBL_SELECT_MODULES_TITLE' => 'Drag and drop to select modules and to change the display order. Perform a search to apply the changes.',
    'LBL_LANGUAGE_PACKS' => 'Language Packs' /*for 508 compliance fix*/,
    'LBL_PATCH_UPGRADES' => 'Patch Upgrades' /*for 508 compliance fix*/,
    'LBL_ADVANCED_SEARCH' => 'Advanced Filter' /*for 508 compliance fix*/,
    'LBL_BASIC_SEARCH' => 'Quick Filter' /*for 508 compliance fix*/,
    'LBL_PROCESSING' => 'Processing' /*for 508 compliance fix*/,

    // OAuth
    'LBL_OAUTH_TITLE' => 'OAuth Keys',
    'LBL_OAUTH' => 'OAuth key management',
    'LBL_OAUTH2_CLIENTS_TITLE' => 'OAuth2 Clients and Tokens',
    'LBL_OAUTH2_CLIENTS' => 'Manage which clients have access to the OAuth2 Server and view session log and revoke active sessions',

    //Sprites Support
    'LBL_SPRITES_NOT_SUPPORTED' => 'Error: Unable to create sprites because the imagecreatetruecolor function cannot be loaded',
    'LBL_SPRITES_CREATING_NAMESPACE' => 'Creating sprite namespace {0}',
    'LBL_SPRITES_PROCESSING_DIR' => 'Processing directory {0}',
    'LBL_SPRITES_ADDED' => 'Added sprite {0}',
    'LBL_SPRITES_EXCLUDING_FILE' => 'Excluding file: {0}',

    //FTS
    'LBL_DELETE_FTS_DATA' => 'Delete existing data when index is performed. Only data in the selected modules will be indexed.',
    'LBL_SAVE_SCHED_BUTTON' => 'Save and Schedule System Index',
    'LBL_REPAIR_UPLOAD_FOLDER' => 'Remove missed files from upload directory',
    'LBL_REPAIR_UPLOAD_FOLDER_DESC' => 'Please note that removal can take a lot of time',
    'LBL_TOTAL_FILES' => 'Total files',
    'LBL_REMOVED_FILES' => 'Removed files',

    'LBL_GOOGLE_SUITE_ADMIN_HEADER' => 'Google Suite',
    'LBL_GOOGLE_SUITE_ADMIN_DESC' => 'Manage your Google Suite Integration.',

    'LBL_JJWG_MAPS_ADMIN_CONFIG_TITLE' => 'Google Maps Settings',
    'LBL_JJWG_MAPS_ADMIN_CONFIG_DESC' => 'Configuration settings to adjust your Google Maps',
    'LBL_JJWG_MAPS_ADMIN_GEOCODED_COUNTS_TITLE' => 'Geocoded Counts',
    'LBL_JJWG_MAPS_ADMIN_GEOCODED_COUNTS_DESC' => 'Shows the number of module objects geocoded, grouped by geocoding response',
    'LBL_JJWG_MAPS_ADMIN_GEOCODE_ADDRESSES_TITLE' => 'Geocode Addresses',
    'LBL_JJWG_MAPS_ADMIN_GEOCODE_ADDRESSES_DESC' => 'Geocode your object addreses. This process may take a few minutes!',
    'LBL_JJWG_MAPS_ADMIN_GEOCODING_TEST_TITLE' => 'Geocoding Test',
    'LBL_JJWG_MAPS_ADMIN_GEOCODING_TEST_DESC' => 'Run a single geocoding test with detailed display results.',
    'LBL_JJWG_MAPS_ADMIN_ADDRESS_CACHE_TITLE' => 'Address Cache',
    'LBL_JJWG_MAPS_ADMIN_ADDRESS_CACHE_DESC' => 'Provides access to Address Cache information. This is only cache.',

    // Google Calendar
    'LBL_GOOGLE_AUTH_TITLE' => 'Google Sync Settings',
    'LBL_GOOGLE_CALENDAR_SETTINGS_TITLE' => 'Google Calendar Settings',
    'LBL_GOOGLE_CALENDAR_SETTINGS_DESC' => 'Configuration settings to adjust your Google Calendar',
    'LBL_GOOGLE_CALENDAR_SETTINGS_JSON' => 'Upload Google API Credentials File',
    'LBL_GOOGLE_CALENDAR_SETTINGS_JSON_HELP' => 'Upload the JSON Credentials file you downloaded from Google Developers Console.',
    'LBL_GOOGLE_CALENDAR_GET_API_KEY' => 'Get API Credentials',

    'LBL_DISPLAY_SIDEBAR' => 'Display Sidebar',
    'LBL_COLOUR_ADMIN_PAGEHEADER' => 'Page header colour',
    'LBL_COLOUR_ADMIN_PAGELINK' => 'Page link colour',
    'LBL_COLOUR_ADMIN_DASHLET' => 'Dashlet colour config',
    'LBL_COLOUR_ADMIN_BASE' => 'Top menu base colour: ',
    'LBL_COLOUR_ADMIN_MENUTOP' => 'Menu top gradient',
    'LBL_COLOUR_ADMIN_MENUBOTTOM' => 'Menu bottom gradient',
    'LBL_COLOUR_ADMIN_MENUBRD' => 'Menu border colour: ',
    'LBL_COLOUR_ADMIN_MENUHOVER' => 'Menu hover colour: ',
    'LBL_COLOUR_ADMIN_DDLINK' => 'Drop down link colour: ',
    'LBL_COLOUR_ADMIN_DDMENU' => 'Drop down menu colour: ',
    'LBL_COLOUR_ADMIN_DDLINK_HOVER' => 'Drop down menu link hover colour: ',
    'LBL_ACTION_MENU_BUTTON' => 'Action Menu button colour',
    'LBL_ACTION_MENU_BACKGROUND' => 'Action Menu background colour',
    'LBL_ACTION_MENU_BACKGROUND_HOVER' => 'Action Menu hover colour',
    'LBL_COLOUR_ADMIN_MENUFONT' => 'Menu link colour',
    'LBL_COLOUR_ADMIN_MENULNKHVR' => 'Menu link hover colour: ',
    'LBL_COLOUR_ADMIN_BTNTOP' => 'Button colour: ',
    'LBL_COLOUR_ADMIN_BTNHOVER' => 'Button hover colour: ',
    'LBL_COLOUR_ADMIN_BTNLNK' => 'Button link colour: ',
    'LBL_COLOUR_ADMIN_BTNLNKHOVER' => 'Button link hover colour: ',
    'LBL_COLOUR_ADMIN_DASHHEAD' => 'Dashlet header colour: ',
    'LBL_COLOUR_ADMIN_DASHHEADTEXT' => 'Dashlet header text colour: ',
    'LBL_COLOUR_ADMIN_ICON' => 'Icon colour: ',
    'LBL_SUGGESTION_POPUP_FROM' => 'Suggestion & Pop-up gradient (from):',
    'LBL_SUGGESTION_POPUP_TO' => 'Suggestion & Pop-up gradient (to):',

    'LBL_MODULE_ADMIN' => 'Module Settings',
    'LBL_MODULE_ADMIN_HEADER_DESC' => 'Configure Module specifics and settings',
    'LBL_AOP_ADMIN_MANAGE_AOP' => 'Case Module Settings',
    'LBL_AOP_ENABLE_AOP' => 'Enable Case Automations',
    'LBL_AOP_ENABLE_PORTAL' => 'Enable External Portal',
    'LBL_AOP_JOOMLA_SETTINGS' => 'Portal Settings',
    'LBL_AOP_JOOMLA_URL' => 'Joomla URL',
    'LBL_AOP_JOOMLA_ACCESS_KEY' => 'Joomla Access Key',
    'LBL_AOP_CASE_ASSIGNMENT' => 'Case Distribution',
    'LBL_AOP_DISTRIBUTION_METHOD' => 'Distribution method',
    'LBL_AOP_ASSIGNMENT_USER' => 'Distribution user',
    'LBL_AOP_ASSIGNMENT_OPTIONS' => 'Distribution target',

    'LBL_AOP_EMAIL_SETTINGS' => 'Email Settings',
    'LBL_AOP_CONTACT_EMAIL_TEMPLATE' => 'Contact Email Template',
    'LBL_AOP_USER_EMAIL_TEMPLATE' => 'User Email Template',
    'LBL_AOP_CASE_CREATION_EMAIL_TEMPLATE' => 'Case Created Email Template',
    'LBL_AOP_CASE_CLOSURE_EMAIL_TEMPLATE' => 'Case Closed Email Template',
    'LBL_AOP_JOOMLA_ACCOUNT_CREATION_EMAIL_TEMPLATE' => 'Joomla Support Portal Account Creation Template',

    'LBL_AOP_BUSINESS_HOURS_SETTINGS' => 'Business Hours',
    'LBL_AOP_BUSINESS_HOURS_DESC' => "Restrict Workflow & Case automations to certain days and times",
    'LBL_SUPPORT_FROM_ADDRESS' => 'Support Email From Address',
    'LBL_SUPPORT_FROM_NAME' => 'Support Email From Name',
    'LBL_CREATE_EMAIL_TEMPLATE' => 'Create',
    'LBL_EDIT_EMAIL_TEMPLATE' => 'Edit',
    'LBL_AOP_SETTINGS' => 'Case Module Settings',

    'LBL_AOP_CASE_STATUS_SETTINGS' => 'Case Status Changes',
    'LBL_AOP_IF_STATUS' => 'If status is',
    'LBL_AOP_THEN_STATUS' => 'change status to',
    'LBL_AOP_ADD_STATUS' => 'Add',
    'LBL_AOP_REMOVE_STATUS' => 'Remove',

    'LBL_AOS_ADMIN_CONTRACT_SETTINGS' => 'Contract Settings',
    'LBL_AOS_ADMIN_CONTRACT_RENEWAL_REMINDER' => 'Renewal Reminder period',
    'LBL_AOS_ADMIN_MANAGE_AOS' => 'Sales Module Settings',
    'LBL_AOS_ADMIN_INVOICE_SETTINGS' => 'Invoice Settings',
    'LBL_AOS_ADMIN_INITIAL_INVOICE_NUMBER' => 'Initial Invoice Number',
    'LBL_AOS_ADMIN_QUOTE_SETTINGS' => 'Quote Settings',
    'LBL_AOS_ADMIN_INITIAL_QUOTE_NUMBER' => 'Initial Quote Number',
    'LBL_AOS_ADMIN_LINE_ITEM_SETTINGS' => 'Line Item Settings',
    'LBL_AOS_ADMIN_ENABLE_LINE_ITEM_GROUPS' => 'Enable Line Items Groups',
    'LBL_AOS_ADMIN_ENABLE_LINE_ITEM_TOTAL_TAX' => 'Add TAX To Line Total',
    'LBL_AOS_SETTINGS' => 'Sales Module Settings',
    'LBL_AOS_DAYS' => 'days',
    'LBL_CHANGE_SETTINGS' => 'Change settings for Quotes, Contracts and Invoices',
    'LBL_CHANGE_SETTINGS_AOD' => 'Change settings for Advanced OpenDiscovery',
    'LBL_CHANGE_SETTINGS_AOP' => 'Change settings for Cases and the Cases Portal',

    'LBL_MANAGE_SECURITYGROUPS_TITLE' => 'Security Suite Group Management',
    'LBL_MANAGE_SECURITYGROUPS' => 'Security Suite Group Editor',
    'LBL_CONFIG_SECURITYGROUPS_TITLE' => 'Security Suite Settings',
    'LBL_CONFIG_SECURITYGROUPS' => 'Configure Security Suite settings such as group inheritance, additive security, etc',

    'LBL_BUSINESS_HOURS' => 'Business hours',
    'LBL_BUSINESS_HOURS_DESC' => "Manage Business Hours",
    'LBL_BUSINESS_HOURS_FROM' => 'From',
    'LBL_BUSINESS_HOURS_TO' => 'To',
    'LBL_BUSINESS_HOURS_OPEN' => "Open",

    'LBL_LIST_SYMBOL' => "List Symbol",
    'LBL_LIST_RATE' => "List Rate",

    'LBL_SYNC_MESSAGE' => "Sync Inbound Email Account. This may take several minutes. Going away from this page will not cancel the process, so feel free to move on or wait for confirmation...",
    'LBL_SYNC_PROCESSING' => "Processing '%s' Inbound Email Account...",
    'LBL_SYNC_ERROR_CONN' => "Connection failed",
    'LBL_SYNC_UPDATED' => "%d record updated",
    'LBL_SYNC_DONE' => "Done Processing Inbound Email Accounts",
    'LBL_SYNC_ERROR_FOUND' => "IMAP errors detected",
    'LBL_SYNC_ALERT_FOUND' => "IMAP alerts detected",
    'LBL_SYNC_NO_EMAIL' => "No imported related Email to Inbound Email Account",
    'LBL_PROCESS_OUTPUT_CLEANUP_ERROR' => "Unable to cleanup output file. Please check permission.",
    'LBL_PROCESS_OUTPUT_WRITE_ERROR' => "Unable to write output file. Please check permission.",
    'LBL_IE_NOT_FOUND' => "Error: invalid Inbound Email Account",

    'LBL_PWDSEC_SETS' => 'Password Security Settings',
    'LBL_PWDSEC_MIN_LENGTH' => 'Password minimum length',
    'LBL_PWDSEC_MIN_LENGTH_DESC' => 'Password minimum length',
    'LBL_PWDSEC_UPPERCASE' => 'Password should contain uppercase characters',
    'LBL_PWDSEC_UPPERCASE_DESC' => 'Password should contain uppercase characters',
    'LBL_PWDSEC_LOWERCASE' => 'Password should contain lowercase characters',
    'LBL_PWDSEC_LOWERCASE_DESC' => 'Password should contain lowercase characters',
    'LBL_PWDSEC_NUMBERS' => 'Password should contain numbers',
    'LBL_PWDSEC_NUMBERS_DESC' => 'Password should contain numbers',
    'LBL_PWDSEC_SPECCHAR' => 'Password should contain special characters',
    'LBL_PWDSEC_SPECCHAR_DESC' => 'Password should contain special characters',
    'LBL_PWDSEC_CHARS' => 'Characters',

    // SearchWrapper
    'LBL_SEARCH_HEADER' => 'Search Settings',
    'LBL_SEARCH_HEADER_DESC' => 'Manage your search preferences',
    'LBL_SEARCH_WRAPPER' => 'Search Settings',
    'LBL_SEARCH_WRAPPER_DESC' => 'Configure the global search preferences for the system',

    // Elasticsearch Settings
    'LBL_ELASTIC_SEARCH' => 'Elasticsearch',
    'LBL_ELASTIC_SEARCH_SETTINGS' => 'Elasticsearch',
    'LBL_ELASTIC_SEARCH_SETTINGS_DESC' => 'Configure Elasticsearch preferences',
    'LBL_ELASTIC_SEARCH_SETTINGS_HELP' => 'Elasticsearch requires an external server set up to work. Read the <a href="https://docs.suitecrm.com/admin/administration-panel/search/elasticsearch/">documentation</a> to learn how.',
    'LBL_ELASTIC_SEARCH_GENERAL' => 'General',
    'LBL_ELASTIC_SEARCH_ENABLE' => 'Enable Elasticsearch.',
    'LBL_ELASTIC_SEARCH_TEST_CONNECTION' => 'Test connection',
    'LBL_ELASTIC_SEARCH_TEST_CONNECTION_SUCCESS' => 'Connection successful.',
    'LBL_ELASTIC_SEARCH_TEST_CONNECTION_FAIL' => 'Connection failed.',
    'LBL_ELASTIC_SEARCH_TEST_CONNECTION_ERROR' => 'Failed perform ping request.',
    'LBL_ELASTIC_SEARCH_SERVER' => 'Server',
    'LBL_ELASTIC_SEARCH_HOST' => 'Host',
    'LBL_ELASTIC_SEARCH_USER' => 'Username',
    'LBL_ELASTIC_SEARCH_PASS' => 'Password',
    'LBL_ELASTIC_SEARCH_SCHEDULERS' => 'Schedulers',
    'LBL_ELASTIC_SEARCH_SCHEDULERS_HELP' => 'The following ElasticSearch schedulers were detected:',
    'LBL_ELASTIC_SEARCH_SCHEDULERS_LAST_RUN' => 'last run:',
    'LBL_ELASTIC_SEARCH_SCHEDULERS_NEVER_RUN' => 'This job has never run',
    'LBL_ELASTIC_SEARCH_SCHEDULERS_NOT_FOUND' => 'No schedulers found. Consider creating one.',
    'LBL_ELASTIC_SEARCH_SCHEDULERS_DESC' => 'The ElasticSearch module uses schedulers to keep the database and the indexing engine synchronised.',
    'LBL_ELASTIC_SEARCH_INDEX' => 'Index',
    'LBL_ELASTIC_SEARCH_INDEX_SCHEDULE_HELP' => 'Schedule an indexing',
    'LBL_ELASTIC_SEARCH_INDEX_SCHEDULE_FULL' => 'Schedule full indexing',
    'LBL_ELASTIC_SEARCH_INDEX_SCHEDULE_PART' => 'Schedule partial indexing',
    'LBL_ELASTIC_SEARCH_INDEX_SCHEDULE_FULL_SUCCESS' => 'A full indexing has been scheduled and will start in the next 60 seconds. Search results might be inconsistent until the process is complete.',
    'LBL_ELASTIC_SEARCH_INDEX_SCHEDULE_FULL_FAIL' => 'Failed to start full index.',
    'LBL_ELASTIC_SEARCH_INDEX_SCHEDULE_PART_SUCCESS' => 'A partial indexing has been scheduled and will start in the next 60 seconds.',
    'LBL_ELASTIC_SEARCH_INDEX_SCHEDULE_PART_FAIL' => 'Failed to start partial index.',

    // SearchWrapper Settings
    'LBL_SEARCH_INTERFACE' => 'Search Interface',
    'LBL_SEARCH_ENGINE' => 'Search Engine',
    'LBL_SEARCH_ENGINE_HELP' => 'Configure the default search engine used by the search.',
    'LBL_SEARCH_ENGINE_TOOLTIP' => 'Select a search engine for the Global Search.',
    'LBL_SEARCH_GENERAL' => 'General',

    'LBL_SEARCH_MODULES' => 'Search Modules',
    'LBL_SEARCH_MODULES_HELP' => 'Select the module(s) that users will be able to search against using the Global Search.',

    // Search Engines Translations
    'LBL_SEARCH_WRAPPER_ENGINES' => 'Search Engines',
    'LBL_BASIC_SEARCH_ENGINE' => 'Basic Search',
    'LBL_BASIC_AND_AOD_ENGINE' => 'Basic + Advanced Search',
    'LBL_ELASTIC_SEARCH_ENGINE' => 'Elasticsearch Engine',
    'LBL_SIMPLE_SQL_SEARCH_ENGINE' => 'Simple SQL Search Engine',

    // SearchWrapper Settings
    'LBL_PDF_HEADER' => 'PDF Settings',
    'LBL_CHANGE_PDF_SETTINGS' => 'Change PDF Settings',
    'LBL_PDF_HEADER_DESC' => 'Manage your PDF preferences',
    'LBL_PDF_OPTIONS' => 'PDF Engine',
    'LBL_PDF_OPTIONS_HELP' => 'Select the PDF engine that users will be able to use.',
    'LBL_PDF_INTERFACE' => 'PDF Interface',

    // PDF Engines Translations
    'LBL_PDF_WRAPPER_ENGINES' => 'PDF Engines',
    'LBL_MPDF_ENGINE' => 'MPDF Engine',

    // Ajax Submit
    'LBL_AJAX_SUBMIT_FAIL' => 'An error has occurred while saving the settings.',

    'LBL_ADMIN_TOOLS_TITLE' => 'Admin Tools',
    'LBL_ADMIN_TOOLS_HEADER_DESC' => 'Repair, upgrade and run diagnosis on your SuiteCRM instance',
    'LBL_WORKFLOW_MANAGER' => 'Workflow Manager',
    'LBL_WORKFLOW_MANAGER_DESC' => 'Manage, Add, delete or change Workflow processes',


    'LBL_WARNING' => 'Warning',
    'LBL_ERROR' => 'Error',
    'LBL_SUBMIT' => 'Submit',
    'LBL_REPAIR_UTF_ENCODING' => 'Repair utf encoding',
    'LBL_REPAIR_UTF_ENCODING_DESC' => 'Repair records with wrongly encoded utf characters',
    'LBL_REPAIR_UTF_ENCODING_DATA_WARNING' => 'The data on your tables is going to be updated.',
    'LBL_REPAIR_UTF_ENCODING_BACKUP_WARNING' => 'Please make sure to backup your database before you run this action.',
    'LBL_REPAIR_UTF_ENCODING_SYNC_WARNING' => 'By default this action will add a job to the job queue. It will normalize records in batches. This requires cron to be configured.',
    'LBL_REPAIR_UTF_ENCODING_ASYNC_WARNING' => 'Running in asynchronous mode. A job should have been added to the job queue. It will normalize records in batches. This requires cron to be configured.',
    'LBL_REPAIR_UTF_ENCODING_ASYNC_PROGRESS_CHECK' => "For progress information, please check the data on the job_queue table entry with name 'repair utf encoding' ",
    'LBL_REPAIR_UTF_ENCODING_SYNC_PROGRESS_CHECK' => "Running in synchronous mode. This action will take a while. For progress information, please check SuiteCRM logs. Check logs with '[utf-normalize]'",
    'LBL_KEEP_TRACKING_TABLES' => 'Keep Tracking tables',
    'LBL_REPAIR_FROM_DATE' => 'Repair from',
    'LBL_REPAIR_UTF_ENCODING_REPAIR_FROM_INVALID' => 'Provided \'Repair from\' value is not valid',
    'LBL_SYNC_RUN' => 'Run Repair Synchronously?',
    'LBL_SYNC_RUNNING' => 'Running in sync mode',
    'LBL_SYNC_RUNNING_INFORMATION_OUTPUT' => 'Do not move away from this page/view. Result information will be displayed.',
    'LBL_SYNC_RUNNING_INFORMATION_LOGS' => "You can also check SuiteCRM logs for more information. Check logs with '[utf-normalize]'",
    'LBL_SYNC_LONG_EXECUTION_WARNING' => 'This action will take a while.',
    'LBL_SYNC_RUN_DESC' => 'Check to run action in synchronous mode. This action will take a while. Please check SuiteCRM logs for progress information. Check logs with \'[utf-normalize]\'',
    'LBL_NORMALIZE_SUCCESS' => 'Normalize records successfully executed',
    'LBL_NORMALIZE_FAILURE' => 'Error while running normalize records',
    'LBL_EXECUTION_STATUS' => 'Execution Status',
    'LBL_EXECUTION_MODE' => 'Execution Mode',
    'LBL_IN_PROGRESS' => 'In Progress',
    'LBL_REPAIRED' => 'Repaired',
    'LBL_SYNCHRONOUS' => 'Synchronous',
    'LBL_ASYNCHRONOUS' => 'Asynchronous',
    'LBL_OUTPUT' => 'OUTPUT',
    'LBL_RESULT' => 'Result'
);
